/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.URISplit;
import org.das2.components.DasProgressPanel;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetURLDemo {
    public static void demoGetCompletions() throws Exception {
        int carotPos;
        String context;
        String spaces = "                                                         ";
        spaces = spaces + spaces + spaces + spaces;
        int test = 4;
        switch (test) {
            case 0: {
                context = "file:/media/mini/data.backup/examples/asciitable/asciiTab.dat?skip=1&column=field1&fill=-9999";
                carotPos = 56;
                break;
            }
            case 1: {
                context = "file:/net/spot3/home/jbf/ct/lanl/gpsdata/omni/omni2_%Y.dat?time=field0&timerange=1960to2010&column=field1&fixedColumns=0-11,54-60&timeFormat=&fill=999.9";
                carotPos = context.indexOf("timeFormat=") + "timeFormat=".length();
                break;
            }
            case 2: {
                context = "file:/net/spot3/home/jbf/ct/lanl/gpsdata/omni/omni2_%Y.dat?time=field0&timerange=1960to2010&&timeFormat=&fill=999.9";
                carotPos = context.indexOf("1960to2010&") + "1960to2010&".length();
                break;
            }
            case 3: {
                context = "vap+bin:file:/net/spot3/home/jbf/ct/lanl/gpsda";
                carotPos = context.indexOf("lanl/gp") + "lanl/gp".length();
                break;
            }
            case 4: {
                context = "vap+bin:file:/n";
                carotPos = context.indexOf(":/n") + ":/n".length();
                break;
            }
            case 5: {
                context = "vap+dat:file:///media/mini/data.backup/examples/asciitable/2490lintest90005.raw?skip=34&co";
                carotPos = context.indexOf("34&co") + "34&co".length();
                break;
            }
            case 6: {
                context = "vap+dat:file:///media/mini/data.backup/examples/asciitable/2490lintest90005.raw?skip=34&racolumn=field2";
                carotPos = context.indexOf("34&ra") + "34&ra".length();
                break;
            }
            default: {
                throw new IllegalArgumentException("bad test number");
            }
        }
        List ccs = DataSetURI.getFactoryCompletions((String)context, (int)carotPos, (ProgressMonitor)DasProgressPanel.createFramed((String)"completions"));
        System.err.println(context);
        System.err.println(spaces.substring(0, carotPos) + "L");
        for (DataSetURI.CompletionResult cc : ccs) {
            System.err.println("" + cc.completion);
        }
    }

    private static List<DataSetURI.CompletionResult> factoryCompletions(String surl, int carotpos) {
        List exts = DataSourceRegistry.getPlugins();
        ArrayList<DataSetURI.CompletionResult> completions = new ArrayList<DataSetURI.CompletionResult>();
        String prefix = surl.substring(0, carotpos);
        String suffix = "";
        if (surl.startsWith("vap:")) {
            suffix = surl.substring(4);
        }
        for (CompletionContext cc : exts) {
            if (!cc.completable.startsWith(prefix)) continue;
            completions.add(new DataSetURI.CompletionResult(cc.completable + suffix, cc.completable, null, cc.completable, false));
        }
        return completions;
    }

    private static List<DataSetURI.CompletionResult> typesCompletions(String surl, int carotpos) {
        List exts = DataSourceRegistry.getPlugins();
        ArrayList<DataSetURI.CompletionResult> completions = new ArrayList<DataSetURI.CompletionResult>();
        String prefix = surl.substring(0, carotpos);
        String suffix = "";
        if (surl.startsWith("vap:")) {
            suffix = surl.substring(4);
        }
        for (CompletionContext cc : exts) {
            if (!cc.completable.startsWith(prefix)) continue;
            completions.add(new DataSetURI.CompletionResult(cc.completable + suffix, cc.completable, null, cc.completable, false));
        }
        return completions;
    }

    private static List<DataSetURI.CompletionResult> hostCompletions(String surl, int carotpos) {
        NullProgressMonitor mon = new NullProgressMonitor();
        List completions = null;
        try {
            completions = DataSetURI.getHostCompletions((String)surl, (int)carotpos, (ProgressMonitor)mon);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return completions;
    }

    private static List<DataSetURI.CompletionResult> fileSystemCompletions(String surl, int carotpos) {
        NullProgressMonitor mon = new NullProgressMonitor();
        List completions = null;
        try {
            completions = DataSetURI.getFileSystemCompletions((String)surl, (int)carotpos, (boolean)true, (boolean)true, null, (ProgressMonitor)mon);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        return completions;
    }

    private static void maybeClearVap(URISplit split) {
        if (split.vapScheme != null && split.vapScheme.equals("vap")) {
            split.vapScheme = null;
            split.formatCarotPos -= 4;
        }
    }

    private static List<DataSetURI.CompletionResult> doit(String surl, int carotpos) {
        List<DataSetURI.CompletionResult> r;
        URISplit split = URISplit.parse((String)surl, (int)carotpos, (boolean)true);
        if (split.resourceUriCarotPos > split.file.length() && DataSourceRegistry.getInstance().hasSourceByExt(DataSetURI.getExt((String)surl))) {
            r = DataSetURLDemo.factoryCompletions(URISplit.format((URISplit)split), split.formatCarotPos);
        } else if (carotpos == 0 || !surl.substring(0, carotpos).contains(":") && (carotpos < 4 && surl.substring(0, carotpos).equals("vap".substring(0, carotpos)) || surl.substring(0, 3).equals("vap"))) {
            r = DataSetURLDemo.typesCompletions(surl, carotpos);
        } else if (carotpos < 6) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/"};
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() < carotpos || !surl.substring(0, carotpos).equals(types[i].substring(0, carotpos))) continue;
                result.add(new DataSetURI.CompletionResult(types[i], ""));
            }
            r = result;
        } else if (surl.startsWith("vap") && surl.substring(0, carotpos).split("\\:", -2).length == 2) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/"};
            String[] sp = surl.substring(0, carotpos).split("\\:", -2);
            String test = sp[1];
            int testCarotpos = carotpos - (sp[0].length() + 1);
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() < testCarotpos || !test.substring(0, testCarotpos).equals(types[i].substring(0, testCarotpos))) continue;
                result.add(new DataSetURI.CompletionResult(sp[0] + ":" + types[i], ""));
            }
            r = result;
        } else {
            int firstSlashAfterHost;
            if (split.scheme != null && split.scheme.equals("file")) {
                if (!surl.startsWith("vap")) {
                    DataSetURLDemo.maybeClearVap(split);
                }
                List<DataSetURI.CompletionResult> r2 = DataSetURLDemo.fileSystemCompletions(URISplit.format((URISplit)split), split.formatCarotPos);
                return r2;
            }
            split.formatCarotPos = split.formatCarotPos - (split.vapScheme == null ? 0 : split.vapScheme.length() - 1);
            split.vapScheme = null;
            int n = firstSlashAfterHost = split.authority == null ? 0 : split.authority.length();
            if (split.resourceUriCarotPos <= firstSlashAfterHost) {
                if (!surl.startsWith("vap")) {
                    DataSetURLDemo.maybeClearVap(split);
                }
                String doHost = URISplit.format((URISplit)split);
                r = DataSetURLDemo.hostCompletions(doHost, split.formatCarotPos);
                if (doHost.endsWith(".gov") || doHost.endsWith(".edu") || doHost.endsWith(".com") || doHost.endsWith(".net")) {
                    r.add(new DataSetURI.CompletionResult(doHost + "/", "explore this host"));
                }
            } else {
                if (!surl.startsWith("vap")) {
                    DataSetURLDemo.maybeClearVap(split);
                }
                r = DataSetURLDemo.fileSystemCompletions(URISplit.format((URISplit)split), split.formatCarotPos);
            }
        }
        return r;
    }

    public static void testAll() throws Exception {
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        registry.discoverFactories();
        registry.discoverRegistryEntries();
        String[] contexts = new String[]{"ftp://papco@mrfrench.lanl.gov", "file:///media/mini/data.backup/examples/multiDay.d2s", "file:/c:/Documents and Settings/jbf/2008-lion and tiger summary.xls", "vap+d2s:file:///media/mini/data.backup/examples/multiDay.d2s"};
        int carotPosOrig = 0;
        for (int j = 0; j < contexts.length; ++j) {
            String context = contexts[j];
            System.err.println("== " + context + " ==");
            for (int carotPos = carotPosOrig; carotPos < context.length(); ++carotPos) {
                List<DataSetURI.CompletionResult> ccs = DataSetURLDemo.doit(context, carotPos);
                if (ccs.size() == 1) {
                    System.err.println(carotPos + "\t" + ccs.size() + "\t" + ccs.get((int)0).completion);
                    continue;
                }
                if (ccs.size() > 1) {
                    System.err.println(carotPos + "\t" + ccs.size() + "\t" + ccs.get((int)0).completion);
                    continue;
                }
                System.err.println(carotPos + "\t" + ccs.size());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DataSetURLDemo.testAll();
        URI uri = DataSetURI.toUri((String)"file:///home/jbf/foo_%25Y.txt");
        System.err.println(uri.toURL());
        URL url = DataSetURI.toUri((String)"file:///home/jbf/foo_%Y.txt").toURL();
        System.err.println(url);
        DataSetURLDemo.demoGetCompletions();
    }
}

